const express = require("express");
const router = express.Router();
const multer = require("multer");
const path = require("path"); // Required for handling file extensions
const dataController = require("../controllers/dataController");

// Configure multer to preserve file extension
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, path.join(__dirname, "../uploads/")); 
  },
  filename: function (req, file, cb) {
    // Use original file name and extension
    cb(
      null,
      file.fieldname + "-" + Date.now() + path.extname(file.originalname)
    );
  },
});

const upload = multer({ storage: storage });

router.post("/upload", upload.single("file"), dataController.uploadExcel);

module.exports = router;