param (
    [string]$ExcelFilePath
)

# Create an Excel application object
$excel = New-Object -ComObject Excel.Application

# Open the Excel file
$workbook = $excel.Workbooks.Open($ExcelFilePath)

# Disable Protected View
$workbook.UnprotectSharing()

# Save the file to remove Protected View
$workbook.Save()

# Close and quit Excel
$workbook.Close()
$excel.Quit()

# Release COM objects
[System.Runtime.Interopservices.Marshal]::ReleaseComObject($workbook) | Out-Null
[System.Runtime.Interopservices.Marshal]::ReleaseComObject($excel) | Out-Null

